/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.fabric;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import ram.talia.moreiotas.api.mod.MoreIotasConfig;
import ram.talia.moreiotas.xplat.IXplatAbstractions;

@Config(name="moreiotas")
@Config.Gui.Background(value="minecraft:textures/block/calcite.png")
public class FabricMoreIotasConfig
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public final Common common = new Common();
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public final Client client = new Client();
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.TransitiveObject
    public final Server server = new Server();

    public static FabricMoreIotasConfig setup() {
        AutoConfig.register(FabricMoreIotasConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        FabricMoreIotasConfig instance = (FabricMoreIotasConfig)AutoConfig.getConfigHolder(FabricMoreIotasConfig.class).getConfig();
        MoreIotasConfig.setCommon(instance.common);
        if (IXplatAbstractions.INSTANCE.isPhysicalClient()) {
            MoreIotasConfig.setClient(instance.client);
        }
        MoreIotasConfig.setServer(instance.server);
        return instance;
    }

    @Config(name="common")
    private static class Common
    implements ConfigData,
    MoreIotasConfig.CommonConfigAccess {
        private Common() {
        }
    }

    @Config(name="client")
    private static class Client
    implements ConfigData,
    MoreIotasConfig.ClientConfigAccess {
        private Client() {
        }
    }

    @Config(name="server")
    private static class Server
    implements ConfigData,
    MoreIotasConfig.ServerConfigAccess {
        @ConfigEntry.BoundedDiscrete(min=3L, max=512L)
        @ConfigEntry.Gui.Tooltip
        private int maxMatrixSize = 144;
        @ConfigEntry.BoundedDiscrete(min=1L, max=32768L)
        @ConfigEntry.Gui.Tooltip
        private int maxStringLength = 1728;
        private double setBlockStringCost = 0.01;
        private double nameCost = 0.01;

        private Server() {
        }

        public void validatePostLoad() throws ConfigData.ValidationException {
            this.maxMatrixSize = this.bound(this.maxMatrixSize, 3, 512);
            this.maxStringLength = this.bound(this.maxStringLength, 1, 32768);
            this.setBlockStringCost = this.bound(this.setBlockStringCost, 1.0E-4, 10000.0);
            this.nameCost = this.bound(this.nameCost, 1.0E-4, 10000.0);
        }

        private int bound(int toBind, int lower, int upper) {
            return Math.min(Math.max(toBind, lower), upper);
        }

        private double bound(double toBind, double lower, double upper) {
            return Math.min(Math.max(toBind, lower), upper);
        }

        @Override
        public int getMaxMatrixSize() {
            return this.maxMatrixSize;
        }

        @Override
        public int getMaxStringLength() {
            return this.maxStringLength;
        }

        @Override
        public long getSetBlockStringCost() {
            return (long)(this.setBlockStringCost * 10000.0);
        }

        @Override
        public long getNameCost() {
            return (long)(this.nameCost * 10000.0);
        }
    }
}

